% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions-OnDiskMSnExp.R
\name{isCentroidedFromFile}
\alias{isCentroidedFromFile}
\title{Get mode from mzML data file}
\usage{
isCentroidedFromFile(x)
}
\arguments{
\item{x}{An object of class \linkS4class{OnDiskMSnExp}.}
}
\value{
A named \code{logical} vector of the same length as \code{x}.
}
\description{
The function extracts the mode (profile or centroided) from the
raw mass spectrometry file by parsing the mzML file directly. If
the object \code{x} stems from any other type of file, \code{NA}s are
returned.
}
\details{
This function is much faster than \code{\link[=isCentroided]{isCentroided()}}, which
estimates mode from the data, but is limited to data stemming from
mzML files which are still available in their original location
(and accessed with \code{fileNames(x)}).
}
\examples{
library("msdata")
f <- proteomics(full.names = TRUE,
                pattern = "TMT_Erwinia_1uLSike_Top10HCD_isol2_45stepped_60min_01.mzML.gz")
x <- readMSData(f, mode = "onDisk")
table(isCentroidedFromFile(x), msLevel(x))
}
\author{
Laurent Gatto
}
