% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{msSummarize}
\alias{msSummarize}
\title{Function for summarizing technical replicates.}
\usage{
msSummarize(
  data,
  cvMax = 0.5,
  minPropPresent = 1/3,
  replicate = "replicate",
  compVars = c("mz", "rt"),
  sampleVars = c("subject_id"),
  colExtraText = NULL,
  separator = NULL,
  missingValue = NA,
  returnSummaryDetails = FALSE,
  returnToSE = FALSE,
  returnToDF = FALSE
)
}
\arguments{
\item{data}{Data set as either a data frame or `SummarizedExperiement`.}

\item{cvMax}{Decimal value from 0 to 1 representing the acceptable level of 
coefficient of variation between replicates.}

\item{minPropPresent}{Decimal value from 0 to 1 representing the 
minimum proportion present to summarize with median or mean. Below this the 
compound will be set to 0.}

\item{replicate}{Name of sample variable specifying replicate. Must match an
element in `sampleVars` or a column in the column data of a 
`SummarizedExperiment`.}

\item{compVars}{Vector of the columns which identify compounds. If a 
`SummarizedExperiment` is used for `data`, row variables will be used.}

\item{sampleVars}{Vector of the ordered sample variables found in each sample
column.}

\item{colExtraText}{Any extra text to ignore at the beginning of the sample 
columns names. Unused for `SummarizedExperiments`.}

\item{separator}{Character or text separating each sample variable in sample
columns. Unused for `SummarizedExperiment`.}

\item{missingValue}{Specifies the abundance value which indicates missing 
data. May be a numeric or `NA`.}

\item{returnSummaryDetails}{Logical value specifying whether to return
details of replicate summarization.}

\item{returnToSE}{Logical value specifying whether to return as 
`SummarizedExperiment`}

\item{returnToDF}{Logical value specifying whether to return as data frame.}
}
\value{
A data frame or `SummarizedExperiment` containing abundance data 
with summarized technical replicates. Default return type is set to match the
data nput but may be altered with the `returnToSE` or `returnToDF` 
arguments. If `returnSummaryDetails` is selected, a list will be returned 
containing the summarized data and a separate tidy data frame with 
summarization details included for each compound/sample pair.
}
\description{
Reads data and summarizes technical replicates as the
mean of observations for compounds found in 2 or 3 replicates and with
coefficient of variation below specified level, or median for those found in
3 replicates but with excessive coefficient of variation (CV). Compounds 
found in only 1 replicate are assigned as missing.
}
\examples{
# Read in data file
data(msquant)

# Summarize technical replicates
summarizedDF <- msSummarize(msquant,
                            compVars = c("mz", "rt"),
                            sampleVars = c("spike", "batch", "replicate", 
                            "subject_id"),
                            cvMax = 0.50,
                            minPropPresent = 1/3,
                            colExtraText = "Neutral_Operator_Dif_Pos_",
                            separator = "_",
                            missingValue = 1)
                            
}
