% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cds2aa.R
\name{cds2aa}
\alias{cds2aa}
\title{cds2aa}
\usage{
cds2aa(
  cds,
  shorten = FALSE,
  frame = 1,
  framelist = NULL,
  genetic.code = NULL,
  return.cds = FALSE
)
}
\arguments{
\item{cds}{\code{DNAStringSet} [mandatory]}

\item{shorten}{shorten all sequences to multiple of three [default: FALSE]}

\item{frame}{indicates the first base of a the first codon [default: 1]}

\item{framelist}{supply vector of frames for each entry [default: NULL]}

\item{genetic.code}{The genetic code to use for the translation of codons
into Amino Acid letters [default: NULL]}

\item{return.cds}{return shorten cds instead of aa [default: FALSE]}
}
\value{
\code{AAStringSet}
}
\description{
This function translates a \code{DNAStringSet} into an
\code{AAStringSet}.
}
\examples{
## define two cds sequences
cds1 <- Biostrings::DNAString("ATGCAACATTGC")
cds2 <- Biostrings::DNAString("ATG---CATTGC")
cds1.cds2.aln <- c(Biostrings::DNAStringSet(cds1),
    Biostrings::DNAStringSet(cds2))
#cds2aa(cds1.cds2.aln)
cds1.cds2.aln |> cds2aa()
## alternative genetic code
data(woodmouse, package="ape")
#cds2aa(dnabin2dnastring(woodmouse), shorten=TRUE)
woodmouse |> dnabin2dnastring() |> cds2aa(shorten=TRUE)
#cds2aa(dnabin2dnastring(woodmouse), shorten=TRUE,
#genetic.code=Biostrings::getGeneticCode("2"))
woodmouse |> dnabin2dnastring() |> cds2aa(shorten=TRUE,
genetic.code=Biostrings::getGeneticCode("2"))
woodmouse |> dnabin2dnastring() |> cds2aa(shorten=TRUE, return.cds=TRUE) |>
cds2aa(genetic.code=Biostrings::getGeneticCode("2"))
}
\seealso{
\code{\link[Biostrings]{XStringSet-class}},
\code{\link[seqinr]{translate}}
}
\author{
Kristian K Ullrich
}
