% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addpos2string.R
\name{addpos2string}
\alias{addpos2string}
\title{addpos2string}
\usage{
addpos2string(seq, chrom = NULL, start = NULL, end = NULL)
}
\arguments{
\item{seq}{\code{DNAStringSet} or \code{AAStringSet} [mandatory]}

\item{chrom}{chromosome name [mandatory]}

\item{start}{start position [mandatory]}

\item{end}{end position [mandatory]}
}
\value{
An object of class \code{DNAStringSet} or \code{AAStringSet}
}
\description{
This function adds \code{GenomicRanges} information,
\code{CHROM}, \code{START} and \code{END} to a
\code{DNAStringSet} or an \code{AAStringSet} and puts them into the
\code{metadata} information.
This information can be used to find overlaps with a chromosome wide mask.
}
\examples{
## load example sequence data
data(iupac, package="MSA2dist")
## add position
iupac <- iupac |> addpos2string(chrom="chr1", start=1, end=1000)
#(iupac |> slot("metadata"))$GRanges
iupac |> getpos()
}
\seealso{
\code{\link[MSA2dist]{addmask2string}},
\code{\link[MSA2dist]{addregion2string}},
\code{\link[MSA2dist]{addpop2string}}
}
\author{
Kristian K Ullrich
}
