% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runPrd.R
\name{runPermPrd}
\alias{runPermPrd}
\title{Run PARADIGM on permuted data}
\usage{
runPermPrd(perml, fpth, outdir,
    PARADIGM_bin=NULL, nohup_bin=NULL, sampleids=NULL, threads=1)
}
\arguments{
\item{perml}{A list of SummarizedExperiment objects of permuted CNA and
RNA states generated by \code{ppPermInp()}.}

\item{fpth}{Name of a pathway file for PARADIGM.}

\item{outdir}{Output folder to save all results.}

\item{PARADIGM_bin}{PARADIGM binary, which can be downloaded from
https://github.com/sng87/paradigm-scripts/tree/master/public/exe. Note that
the binary is only available for Linux or MacOS. Default: NULL}

\item{nohup_bin}{nohup binary, which is used for long running PARADIGM jobs.
Default: NULL}

\item{sampleids}{A vector of sample IDs to run PARADIGM on. If not provided,
all the samples that exist in both copy-number alteration
and RNA files will be ran. Default: NULL}

\item{threads}{Number of threads to run in parallel. Default: 1}
}
\value{
None
}
\description{
Run PARADIGM on permuted data
}
\examples{

fperm = system.file('extdata/TcgaInp/inp_perm.rds', package='MPAC')
perml = readRDS(fperm)
fpth = system.file('extdata/Pth/tiny_pth.txt', package='MPAC')
outdir = tempdir()
paradigm_bin = '/path/to/PARADIGM'  ## change to binary location
pat = 'TCGA-CV-7100'

# depends on external PARADIGM binary, do not run
runPermPrd(perml, fpth, outdir, paradigm_bin, sampleids=c(pat))

}
