% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fltByPerm.R
\name{fltByPerm}
\alias{fltByPerm}
\title{Filter IPLs from real data by distribution from permuted data}
\usage{
fltByPerm(realdt, permdt, threads = 1)
}
\arguments{
\item{realdt}{A data.table object containing entities and their IPLs from
real data. It is the output from \code{colRealIPL()}.}

\item{permdt}{A data.table object containing permutation index, entities
and their IPLs from permuted data. It is the output from
\code{colPermIPL()}.}

\item{threads}{Number of threads to run in parallel. Default: 1}
}
\value{
A matrix of filtered IPLs with rows as entities and columns as
samples. Entities with IPLs observed by chance are set to NA.
}
\description{
Filter IPLs from real data by distribution from permuted data
}
\examples{

freal = system.file('extdata/fltByPerm/real.rds', package='MPAC')
fperm = system.file('extdata/fltByPerm/perm.rds', package='MPAC')
realdt = readRDS(freal)
permdt = readRDS(fperm)

fltByPerm(realdt, permdt)

}
