% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supertest&frequencyplot.R
\name{stripModulesFromPathways}
\alias{stripModulesFromPathways}
\title{Remove Module Number From Pathway Name}
\usage{
stripModulesFromPathways(pathways)
}
\arguments{
\item{pathways}{vector of pathway names}
}
\value{
list of pathway names without the module number
}
\description{
Function to remove the suffix corresponding to the module number of the
pathway name. Necessary step for \code{\link{annotePathwayToFather}} and
\code{\link{plotFrequencies}}
}
\examples{
pathwaysModules <- list(
    "Intrinsic Pathway for Apoptosis.1",
    "Intrinsic Pathway for Apoptosis.2",
    "Opioid Signalling.1", "Opioid Signalling.2"
)

resPathwayNames <- stripModulesFromPathways(pathwaysModules)

}
