% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlottingMO.R
\name{plotPathwayKM}
\alias{plotPathwayKM}
\title{Plot Kaplan-Meier survival curves of a specific pathway}
\usage{
plotPathwayKM(
  pathway,
  formula = "Surv(days, status) ~ PC1",
  fileName = NULL,
  paletteNames = NULL,
  h = 9,
  w = 7,
  risk.table = TRUE,
  pval = TRUE,
  size = 1,
  inYears = FALSE,
  discr_prop_pca = 0.15,
  discr_prop_events = 0.05,
  additional_discrete = NULL,
  additional_continuous = NULL,
  ...
)
}
\arguments{
\item{pathway}{\code{MultiOmicsPathway} class object}

\item{formula}{a formula to compute the plot}

\item{fileName}{optional filenames to save the plot}

\item{paletteNames}{a palette containing three colors}

\item{h}{the height of the plot}

\item{w}{the width of the plot}

\item{risk.table}{logical value. If TRUE, shows the \code{risk.table}. Default
is TRUE.}

\item{pval}{logical value. Shows p-value of the curves}

\item{size}{line width of the KM curves}

\item{inYears}{logical value. If TRUE, converts days to years}

\item{discr_prop_pca}{the minimal proportion to compute the PCA classes}

\item{discr_prop_events}{the minimal proportion to compute the event classes}

\item{additional_discrete}{names of the additional discrete variables to
include}

\item{additional_continuous}{names of the additional continuous variables to
include}

\item{...}{additional arguments passed to \code{guessInvolvementPathway} and
\code{get} function (internal use)}
}
\value{
a ggsurvplot class object
}
\description{
Given a \code{MultiOmicsPathway} class object, it plots Kaplan-Meier curves,
in which the strata corresponds to the chosen omics
}
\examples{
data(multiOmics)
data(reactSmall)

genesToUse <- row.names(multiOmics[[1]])

# Creating the MultiOmicsPathway object
MOP_survival <- multiOmicsSurvivalPathwayTest(multiOmics, reactSmall[[1]],
    survFormula = "Surv(days, status) ~", autoCompleteFormula = TRUE,
    useTheseGenes = genesToUse
)

plotPathwayKM(MOP_survival,
    formula = "Surv(days, status) ~ mut + expPC2",
    paletteNames = "Paired", inYears = TRUE
)

}
