% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiOmicsGlmTest.R
\name{multiOmicsTwoClassPathwayTest}
\alias{multiOmicsTwoClassPathwayTest}
\title{Compute Multi Omics Two-Class in Pathways}
\usage{
multiOmicsTwoClassPathwayTest(
  omicsObj,
  graph,
  classAnnot,
  baseFormula = "classes ~ ",
  autoCompleteFormula = TRUE,
  useTheseGenes = NULL,
  nullModel = "classes ~ 1",
  pathName = NULL
)
}
\arguments{
\item{omicsObj}{object of class \code{Omics}}

\item{graph}{a pathway as a \code{graphNEL} object.}

\item{classAnnot}{a \code{data.frame} with the class annotation. It is necessary
at least a column with the classes labels, and the row.names as the samples
labels}

\item{baseFormula}{model formula to be used for the test. It should be
written as 'classes ~ ', while 'classes' being the column name for the class
labels}

\item{autoCompleteFormula}{a logical value. If TRUE. It autocompletes the
formula used to fit generalized lienar models function  using all the
available covariates (omics)}

\item{useTheseGenes}{(optional) vector of specific genes to be used}

\item{nullModel}{the null model formula. It should be written the same as
the baseFormula, followed by ' 1'. (e.g. 'classes ~ 1')}

\item{pathName}{(optional) title of the pathway. If NULL, \code{graph@title} is
used as title}
}
\value{
\code{MultiOmicsPathway} object
}
\description{
Performs topological two-class analysis using an \code{Omics} object.
}
\examples{
data("multiOmics")
data("reactSmall")

genesToUse <- row.names(multiOmics[[1]])

classAnnot <- data.frame(
    "treatment" = c(rep("A", 25), rep("B", 25)),
    row.names = colnames(multiOmics[[1]])
)

MOP_twoClasses <- multiOmicsTwoClassPathwayTest(
    multiOmics, reactSmall[[1]], classAnnot,
    baseFormula = "treatment ~ ", nullModel = "treatment ~ 1",
    useTheseGenes = genesToUse
)

}
