% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractSummary.R
\name{extractSummaryFromNumberOfEvents}
\alias{extractSummaryFromNumberOfEvents}
\title{Extract Summary Binary from MultiOmics Objects}
\usage{
extractSummaryFromNumberOfEvents(
  omic,
  multiOmicObj,
  moduleCox,
  analysis,
  n = 3,
  minprop = 0.1,
  labels = c("few", "many")
)
}
\arguments{
\item{omic}{a summarized omic}

\item{multiOmicObj}{\code{Omics} object}

\item{moduleCox}{the coxObj of the interesting module}

\item{analysis}{two-class or survival type}

\item{n}{maximum number of features to retrieve}

\item{minprop}{the minimal proportion of cutp}

\item{labels}{the category labels}
}
\value{
Meant for internal use only. The summary for omic summarized using
counting of events.
\item{sigModule}{the original data for significant features}
\item{discrete}{the discrete version of the significant covariates converted
(when needed) into the discrete version}
\item{subset}{data.frame(row.names=names(topGenes), covariates=covariate)}
\item{covsConsidered}{the name of the considered omic}
}
\description{
Given an omic summarized by 'summarizeToNumberOfEvents' extract the most
important features.
}
