% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/houseClip-pca-functions.R
\name{computePCs}
\alias{computePCs}
\title{compute PCs.}
\usage{
computePCs(
  exp,
  shrink = FALSE,
  method = c("regular", "topological", "sparse"),
  cliques = NULL,
  maxPCs = 3
)
}
\arguments{
\item{exp}{a matrix}

\item{shrink}{logical, whether to shrink or not.}

\item{method}{one of 'regular', 'topological' and 'sparse'}

\item{cliques}{the pathway topology summarized in a list of cliques}

\item{maxPCs}{the maximum number of PCs to consider}
}
\value{
a list with the following elements:
\item{x}{the computed PCs}
\item{sdev}{the standard deviation captured by the PCs}
\item{loadings}{the loadings}
}
\description{
For internal use only. Performs Principal Componenent analysis.
}
\details{
Three methods are implemented:
\itemize{
\item regular: a regular PCA ('prcomp')
\item topological: PCA using a pathway topology.
\item sparse: sparse PCA analysis implemented by 'elasticnet'
}
}
