% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supertest&frequencyplot.R
\name{annotePathwayToFather}
\alias{annotePathwayToFather}
\title{Find Pathway Fathers}
\usage{
annotePathwayToFather(pathways, graphiteDB, hierarchy)
}
\arguments{
\item{pathways}{vector of pathway names}

\item{graphiteDB}{graphite DB object (e.g. an object containing all reactome
pathways)}

\item{hierarchy}{a graph object with the pathway hierarchy}
}
\value{
a vector of the pathway fathers' names
}
\description{
Given the hierarchy of the pathways, this formula finds the fathers of the
respective pathway (e.g. pathway: 'PI3K Cascade'; father:
'Signaling Pathways'). This function is necessary for calculating the
contribution of different omics to survival prediction in different
biological processes, grouping the pathways by hierarchy.
}
\examples{
data(multiOmics)
data(reactSmall)

genesToUse <- row.names(multiOmics[[1]])

MOM_list <- lapply(reactSmall[1:2], function(g) {
    fcl <- multiOmicsSurvivalModuleTest(multiOmics, g,
        survFormula = "Surv(days, status) ~",
        autoCompleteFormula = TRUE,
        useTheseGenes = genesToUse
    )
    fcl
})

moduleSummary <- multiPathwayModuleReport(MOM_list)

pathHierarchy <- downloadPathwayRelationFromReactome()
pathHierarchyGraph <- igraph::graph.data.frame(
    d = pathHierarchy,
    directed = TRUE
)

omicsClasses2pathways <- computeOmicsIntersections(
    moduleSummary,
    pvalueThr = 1, zscoreThr = 1,
    excludeColumns = c("pathway", "module")
)

omicsClasses2pathways <- lapply(
    omicsClasses2pathways,
    stripModulesFromPathways
)

# This step requires to download the whole reactome graph, which usually
# takes a lot of time.
# reactome <- graphite::pathways('hsapiens', 'reactome')
# reactome <- graphite::convertIdentifiers(reactome, 'entrez')
# omicsClasses2fathers <- lapply(omicsClasses2pathways, 
#                                annotePathwayToFather, 
#                                graphiteDB = reactome,
#                                hierarchy = pathHierarchyGraph)

}
