% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{package}
\name{MOSClip}
\alias{MOSClip-package}
\alias{MOSClip}
\title{MOSClip: Multi-Omics Survival Clip}
\description{
\code{MOSClip} R package implements a statistical approach able to integrate
multi-omic data and look for survival associated gene modules. It
integrates multiple omics - trascriptomics, methylomics, genomic
mutations, and genomic copy number variations - using various data
dimensionality reduction strategies and multivariate models. Exploiting
graph theory, pathways can be decomposed into their connected
components, that we call modules. The analysis can then be performed at
the level of entire pathways or pathway modules. \code{MOSClip} pathway
analysis serves two primary purposes: testing the survival association
of pathways or modules using the Cox proportional hazard model, and
conducting a two-class analysis with a generalized linear model.
Additionally, the package offers valuable graphical tools to visualize
and interpret the results.
}
\details{
To conduct a multi-omic survival analysis on pathways or modules use:
\itemize{
\item \code{\link{multiOmicsSurvivalPathwayTest}}
\item \code{\link{multiOmicsSurvivalModuleTest}}
}

To perform a two-class comparison enrichment analysis on pathways or modules
use:
\itemize{
\item \code{\link{multiOmicsTwoClassPathwayTest}}
\item \code{\link{multiOmicsTwoClassModuleTest}}
}
}
\references{
Paolo Martini, Monica Chiogna, Enrica Calura,
and Chiara Romualdi. 2019. “MOSClip: Multi-Omic and Survival Pathway
Analysis for the Identification of Survival Associated Gene and Modules.”
Nucleic Acids Research 47 (14): e80. \url{https://doi.org/10.1093/nar/gkz324}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/CaluraLab/MOSClip/}
  \item Report bugs at \url{https://github.com/CaluraLab/MOSClip/issues}
}

}
\author{
\strong{Maintainer}: Paolo Martini \email{paolo.martini@unibs.it} (\href{https://orcid.org/0000-0002-0146-1031}{ORCID})

Authors:
\itemize{
  \item Anna Bortolato \email{anna.bortolato@unipd.it} (\href{https://orcid.org/0009-0009-9327-6084}{ORCID})
  \item Anna Tanada \email{annacarolinaemi.delimatanada@phd.unipd.it} (\href{https://orcid.org/0000-0003-3224-0538}{ORCID})
  \item Enrica Calura \email{enrica.calura@unipd.it} (\href{https://orcid.org/0000-0001-8463-2432}{ORCID})
  \item Stefania Pirrotta \email{stefania.pirrotta@phd.unipd.it} (\href{https://orcid.org/0009-0004-0030-217X}{ORCID})
  \item Federico Agostinis \email{federico.agostinis@outlook.com}
}

}
