% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MODA.R
\name{WeightedModulePartitionSpectral}
\alias{WeightedModulePartitionSpectral}
\title{Modules detection by spectral clustering}
\usage{
WeightedModulePartitionSpectral(datExpr, foldername, indicatename, GeneNames,
  power = 6, nn = 10, k = 2)
}
\arguments{
\item{datExpr}{gene expression profile, rows are samples and columns genes}

\item{foldername}{where to store the clusters}

\item{indicatename}{normally a specific tag of condition}

\item{GeneNames}{normally the gene official names to replace the colnames of datExpr}

\item{power}{the power parameter of WGCNA, W_{ij}=|cor(x_i,x_j)|^power}

\item{nn}{the number of nearest neighbor, used to construct the affinity matrix}

\item{k}{the number of clusters(modules)}
}
\value{
None
}
\description{
Module detection based on the spectral clustering algorithm, which mainly
solve the eigendecomposition on Laplacian matrix
}
\examples{
data(synthetic)
ResultFolder <- 'ForSynthetic' # where middle files are stored
indicator <- 'X'     # indicator for data profile 1
GeneNames <- colnames(datExpr1)
WeightedModulePartitionSpectral(datExpr1,ResultFolder,indicator,
GeneNames,k=5)
truemodule <- c(rep(1,100),rep(2,100),rep(3,100),rep(4,100),rep(5,100))
#mymodule <- getPartition(ResultFolder)
#randIndex(table(mymodule,truemodule),adjust=F)
}
\author{
Dong Li, \email{dxl466@cs.bham.ac.uk}
}
\references{
Von Luxburg, Ulrike. "A tutorial on spectral clustering." 
Statistics and computing 17.4 (2007): 395-416.
}
\keyword{cutting}
\keyword{dendrogram}

