% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{enrichmentMethod}
\alias{enrichmentMethod}
\title{Access the method used for functional enrichment analyses}
\usage{
enrichmentMethod(object)
}
\arguments{
\item{object}{An object of class
\code{\link[=FunctionalEnrichment-class]{FunctionalEnrichment}} containing
enrichment results}
}
\value{
A \code{character} containing the enrichment method, such as \code{GSEA}.
}
\description{
This function accesses the \code{method} slot of a
\code{\link[=FunctionalEnrichment-class]{FunctionalEnrichment}} object and returns
a the name of the enrichment strategy used by the \code{\link[=enrichGenes]{enrichGenes()}} function
to perform the enrichment analysis.
}
\examples{
# load example FunctionalEnrichment object
obj <- loadExamples("FunctionalEnrichment")

# see the method
enrichmentMethod(obj)

}
\author{
Jacopo Ronchi, \email{jacopo.ronchi@unimib.it}
}
