% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{enrichmentBarplot}
\alias{enrichmentBarplot}
\title{Create a barplot for functional enrichment analysis}
\usage{
enrichmentBarplot(
  enrichment,
  showTerms = 10,
  showTermsParam = "ratio",
  splitDir = TRUE,
  title = NULL
)
}
\arguments{
\item{enrichment}{An object of class
\code{\link[=FunctionalEnrichment-class]{FunctionalEnrichment}} containing
enrichment results}

\item{showTerms}{It is the number of terms to be shown, based on the
order determined by the parameter \code{showTermsParam}; or, alternatively, a
character vector indicating the terms to plot. Default is \code{10}}

\item{showTermsParam}{The order in which the top terms are selected as
specified by the \code{showTerms} parameter. It must be one of \code{ratio} (default),
\code{padj}, \code{pval} and \code{overlap}}

\item{splitDir}{Logical, if \code{TRUE} the resulting plot will be divided in
two columns on the basis of enrichment direction (Up and Down).
Default is \code{TRUE}. This only applies if enrichment method is GSEA or CAMERA}

\item{title}{The title of the plot. Default is \code{NULL} not to include a plot
title}
}
\value{
A \code{ggplot} graph with a barplot of enrichment results.
}
\description{
This function produces a barplot to show the results of functional
enrichment analyses carried out through over-representation analysis (ORA),
gene set enrichment analysis (GSEA), and competitive gene set test accounting
for inter-gene correlation (CAMERA). In particular, this function can take
as input enrichment results generated by the \code{\link[=enrichGenes]{enrichGenes()}} function.
}
\details{
When producing a barplot with this function, significant pathways are
ordered on the x-axis on the basis of the ratio between the number of
overlapping genes in that set, and the total number of genes in the set.
Moreover, the color scale of dots is relative to the adjusted p-values of
each category.
}
\examples{
# load example FunctionalEnrichment object
obj <- loadExamples("FunctionalEnrichment")

# plot results
enrichmentBarplot(obj)

}
\author{
Jacopo Ronchi, \email{jacopo.ronchi@unimib.it}
}
