% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{pairedSamples}
\alias{pairedSamples}
\title{View the relationship between miRNA and gene samples}
\usage{
pairedSamples(object)
}
\arguments{
\item{object}{A \code{\link[=MirnaExperiment-class]{MirnaExperiment}} object containing
miRNA and gene data}
}
\value{
A \code{logical} value that is either \code{TRUE} for paired samples, or \code{FALSE} for
unpaired samples.
}
\description{
This function allows to access the \code{pairedSamples} slot of a
\code{\link[=MirnaExperiment-class]{MirnaExperiment}} object. The \code{MirnaExperiment}
class is able to contain miRNA and gene expression measurements deriving
from the same individuals (paired samples), or from different subjects
(unpaired samples).
}
\examples{
# load example MirnaExperiment object
obj <- loadExamples()

# check if an existing MirnaExperiment object derive from paired samples
pairedSamples(obj)

}
\author{
Jacopo Ronchi, \email{jacopo.ronchi@unimib.it}
}
