% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/association.R
\name{getEvidence}
\alias{getEvidence}
\title{Get the scientific evidence for a particular disease-SNP association}
\usage{
getEvidence(variant, diseaseEFO)
}
\arguments{
\item{variant}{The SNP ID of a particular variant of interest
(e.g. 'rs394581')}

\item{diseaseEFO}{The EFO identifier of a disease of interest. This can be
identified with the function \code{\link[=searchDisease]{searchDisease()}}}
}
\value{
A \code{tbl_df} dataframe containing information about literature evidences for a
disease-SNP association.
}
\description{
This function returns the biomedical evidence that supports the association
between a particular SNP and a phenotypic trait.
}
\note{
To retrieve evidences of disease-SNP association, this function makes use of
the \code{gwasrapidd} package.
}
\examples{
\donttest{
# searchDisease("Alzheimer disease")
evidence <- getEvidence("rs2075650", diseaseEFO = "Alzheimer disease")
}

}
\references{
Ramiro Magno, Ana-Teresa Maia, gwasrapidd: an R package to query, download
and wrangle GWAS catalog data, Bioinformatics, Volume 36, Issue 2, January
2020, Pages 649–650, \url{https://doi.org/10.1093/bioinformatics/btz605}.
}
\author{
Jacopo Ronchi, \email{jacopo.ronchi@unimib.it}
}
