% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{MirnaExperiment}
\alias{MirnaExperiment}
\title{The constructor function for \linkS4class{MirnaExperiment}}
\usage{
MirnaExperiment(mirnaExpr, geneExpr, samplesMetadata, pairedSamples = TRUE)
}
\arguments{
\item{mirnaExpr}{A \code{matrix} object containing microRNA expression levels.
Other objects coercible to \code{matrix} are also accepted (e.g. \code{data.frame}).
This object must be structured as specified in the \emph{details} section}

\item{geneExpr}{A \code{matrix} object containing gene expression levels.
Other objects coercible to \code{matrix} are also accepted (e.g. \code{data.frame}).
This object must be structured as specified in the \emph{details} section}

\item{samplesMetadata}{A \code{data.frame} object containing information about
samples used for microRNA and gene expression profiling. For further
information see the \emph{details} section}

\item{pairedSamples}{Logical, whether miRNA and gene expression levels
derive from the same subjects or not. Check the \emph{details} section for
additional instructions. Default is \code{TRUE}}
}
\value{
A valid \code{\link[=MirnaExperiment-class]{MirnaExperiment}} object containing
information about miRNA and gene expression.
}
\description{
This is the constructor function that allows to easily create objects of
class \code{\link[=MirnaExperiment-class]{MirnaExperiment}}. This function requires as
inputs miRNA and gene expression matrices, as well as sample metadata.
}
\details{
This function requires data to be prepared as described below.
\subsection{mirnaExpr and geneExpr}{

\code{mirnaExpr} and \code{geneExpr} must be \code{matrix} objects (or objects coercible
to one) that contain miRNA and gene expression values, respectively.
Rows must represent the different miRNAs/genes analyzed while columns must
represent the different samples in study. For \code{mirnaExpr}, row names must
contain miRNA names according to miRBase nomenclature, whereas for
\code{geneExpr}, row names must contain gene symbols according to hgnc
nomenclature. The values contained in these objects can derive from both
microarray and RNA-Seq experiments.

For NGS experiments, \code{mirnaExpr} and \code{geneExpr} should just be un-normalized
count matrices. Instead, for microarray experiments, data should be
normalized and log2 transformed, for example with the RMA algorithm.
}

\subsection{samplesMetadata}{

\code{samplesMetadata} must be a \code{data.frame} object containing information about
samples used for miRNA profiling and for gene expression analysis.
Specifically, this data.frame must contain:
\itemize{
\item A column named \code{primary}, specifying an identifier for each sample;
\item A column named \code{mirnaCol}, containing the column names used for each
sample in the \code{mirnaExpr} object;
\item A column named \code{geneCol}, containing the column names used for each
sample in the \code{geneExpr} object;
\item Other eventual columns that define specific sample metadata, such as
disease condition, age, sex and so on...
}

For unpaired samples, NAs can be used for missing entries in
\code{mirnaCol}/\code{geneCol}.
}

\subsection{pairedSamples}{

MicroRNA and gene expression measurements may derive from the same subjects
(i.e. samples used to generate both miRNA and gene expression data) or from
different individuals (i.e. miRNA expression assayed on a group of samples
and gene expression retrieved from a different group of samples).
\code{pairedSamples} is a \code{logical} parameter that defines the relationship
between miRNA and gene expression measurements. It must be \code{TRUE} if data
derive from the same individuals, while it must be \code{FALSE} when data derive
from different subjects.
}
}
\examples{
# load example data
data(geneCounts, package = "MIRit")
data(mirnaCounts, package = "MIRit")

# create samples metadata
meta <- data.frame(
    "primary" = colnames(geneCounts),
    "mirnaCol" = colnames(mirnaCounts), "geneCol" = colnames(geneCounts),
    "disease" = c(rep("PTC", 8), rep("NTH", 8)),
    "patient" = c(rep(paste("Sample_", seq(8), sep = ""), 2))
)

# create a 'MirnaExperiment' object
obj <- MirnaExperiment(
    mirnaExpr = mirnaCounts, geneExpr = geneCounts,
    samplesMetadata = meta, pairedSamples = TRUE
)

}
\author{
Jacopo Ronchi, \email{jacopo.ronchi@unimib.it}
}
