% Generated by roxygen2 (4.0.1): do not edit by hand
\name{runBayesFit}
\alias{runBayesFit}
\title{Running the BayesFit optimisation}
\usage{
runBayesFit(opts)
}
\arguments{
\item{opts}{list with entries as explained below.
  Options set -- defines the problem and sets some
  parameters to control the MCMC algorithm.
model: List of model parameters - to estimate.
  The parameter objects must each have a
  'value' attribute containing the parameter's numerical value.
estimate_params: list.
  List of parameters to estimate, all of which must also be listed
  in 'options$model$parameters'.
initial_values: list of float, optional.
  Starting values for parameters to estimate. If omitted, will use
  the nominal values from 'options$model$parameters'
step_fn: callable f(output), optional.
  User callback, called on every MCMC iteration.
likelihood_fn: callable f(output, position).
  User likelihood function.
prior_fn: callable f(output, position), optional.
  User prior function. If omitted, a flat prior will be used.
nsteps: int.
  Number of MCMC iterations to perform.
use_hessian: logical, optional.
  Wheter to use the Hessian to guide the walk. Defaults to FALSE.
rtol: float or list of float, optional.
  Relative tolerance for ode solver.
atol: float or list of float, optional.
  Absolute tolerance for ode solver.
norm_step_size: float, optional.
  MCMC step size. Defaults to a reasonable value.
hessian_period: int, optional.
  Number of MCMC steps between Hessian recalculations. Defaults
  to a reasonable but fairly large value, as Hessian calculation is expensive.
hessian_scale: float, optional.
  Scaling factor used in generating Hessian-guided steps. Defaults to a
  reasonable value.
sigma_adj_interval: int, optional.
  How often to adjust 'output$sig_value' while annealing to meet
  'accept_rate_target'. Defaults to a reasonable value.
anneal_length: int, optional.
  Length of initial "burn-in" annealing period. Defaults to 10% of
  'nsteps', or if 'use_hessian' is TRUE, to 'hessian_period' (i.e.
  anneal until first hessian is calculated)
T_init: float, optional.
  Initial temperature for annealing. Defaults to a resonable value.
accept_rate_target: float, optional.
  Desired acceptance rate during annealing. Defaults to a reasonable value.
  See also 'sigma_adj_interval' above.
sigma_max: float, optional.
  Maximum value for 'output$sig_value'. Defaults to a resonable value.
sigma_min: float, optional.
  Minimum value for 'output$sig_value'. Defaults to a resonable value.
sigma_step: float, optional.
  Increment for 'output$sig_value' adjustments. Defaults to a resonable
  value. To eliminate adaptive step size, set sigma_step to 1.
thermo_temp: float in the range [0,1], optional.
  Temperature for thermodynamic integration support. Used to scale
  likelihood when calculating the posterior value. Defaults to 1,
  i.e. no effect.}
}
\value{
The output after the optimisation is finished - a list with entries as explained in 'Arguments'.
}
\description{
"runBayesFit" defines the prior function and runs the BayesFit estimation
}


\examples{

data("simpleExample", package="MEIGOR")
initial_pars = createLBodeContPars(model, LB_n=1, LB_k=0.1, LB_tau=0.01, UB_n=5, UB_k=0.9, UB_tau=10, random=TRUE)
simData = plotLBodeFitness(cnolist, model, initial_pars, reltol=1e-05, atol=1e-03, maxStepSize=0.01)

f_bayesFit <- function(position, params=initial_pars, exp_var=opts$exp_var) {
	# convert from log
	params$parValues = 10^position
	ysim = getLBodeDataSim(cnolist=cnolist, model=model,
	ode_parameters=params)
	data_as_vec = unlist(cnolist$valueSignals)
	sim_as_vec = unlist(ysim)
	# set nan (NAs) to 0
	sim_as_vec[is.na(sim_as_vec)] = 0
	sim_as_vec[is.nan(sim_as_vec)]= 0
	return(sum((data_as_vec-sim_as_vec)^2/(2*exp_var^2)))
}

prior_mean = log10(initial_pars$parValues)
prior_var = 10

opts <- list("model"=NULL, "estimate_params"=NULL,"initial_values"=NULL,
"tspan"=NULL, "step_fn"=NULL, "likelihood_fn"=NULL,
"prior_fn"=NULL, "nsteps"=NULL, "use_hessian"=FALSE,
"rtol"=NULL, "atol"=NULL, "norm_step_size"=0.75,
"hessian_period"=25000, "hessian_scale"=0.085,
"sigma_adj_interval"=NULL, "anneal_length"=NULL,
"T_init"=10, "accept_rate_target"=0.3, "sigma_max"=1,
"sigma_min"=0.25, "sigma_step"=0.125, "thermo_temp"=1, "seed"=NULL)
opts$nsteps = 2000
opts$likelihood_fn = f_bayesFit
opts$use_hessian = TRUE
opts$hessian_period = opts$nsteps/10
opts$model = list(parameters=list(name=initial_pars$parNames,
value=initial_pars$parValues))
opts$estimate_params = initial_pars$parValues
opts$exp_var = 0.01

res = runBayesFit(opts)

initial_pars$parValues = cur_params(output=res, options=opts)

}

