% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_helper.R
\name{percentileNorm}
\alias{percentileNorm}
\title{Percentile Normalization}
\usage{
percentileNorm(cnts, meta)
}
\arguments{
\item{cnts}{A numeric matrix  of abundances (samples x features).}

\item{meta}{Data-frame of covariate columns, first column contains batches,
second column contains grouping.}
}
\value{
Numeric matrix of corrected/normalized counts.
}
\description{
Wrapper to help perform percentile normalization on a matrix of counts.
Takes counts and a data-frame of grouping variables and returns a matrix of
transformed counts. This is designed (by the Developers of the procedure) to
work with case/control experiments by taking the untreated group as reference
and adjusting the other groupings of TRT x Batch to it.
}
\details{
The function returns a matrix of normalized abundances.
}
\examples{
# This will return a matrix of normalized counts, according to the covariate
# information in meta
data(dummy.list)
mtx.pn_counts <- percentileNorm(cnts=dummy.list$cnts,
meta=dummy.list$meta[,c("batch","group")])
}
\keyword{Normalization}
\keyword{Percentile}
