% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_analyses.R
\name{mbecRLE}
\alias{mbecRLE}
\title{Relative Log Expression Plot}
\usage{
mbecRLE(
  input.obj,
  model.vars = c("batch", "group"),
  type = "clr",
  label = character(),
  return.data = FALSE
)
}
\arguments{
\item{input.obj}{MbecData-object}

\item{model.vars}{two covariates of interest to select by. First relates to
'batch' and the second to relevant grouping.}

\item{type}{Which abundance matrix to use for the calculation.}

\item{label}{Which corrected abundance matrix to use for analysis.}

\item{return.data}{logical if TRUE returns the data.frame required for
plotting. Default (FALSE) will return plot object.}
}
\value{
Either a ggplot2 object or a formatted data-frame to plot from.
}
\description{
Takes two covariates, i.e., group and batch, and computes the RLE-plot over
the grouping of the first covariate, colored by the second covariate.
Effectively illustrating the relative expression between samples from
different batches within the respective study groups. Other covariates can be
chosen as input and the function will check for factors and convert if
necessary. Categorical factors, e.g., group membership, sex and batch,
produce the best result.
}
\details{
The function returns either a plot-frame or the finished ggplot object. Input
is an MbecData-object. If cumulative log-ratio (clr) and total sum-scaled
(tss) abundance matrices are part of the input, i.e., 'mbecTransform()' was
used, they can be selected as input by using the 'type' argument with either
"otu", "clr" or "tss". If batch effect corrected matrices are available, they
can be used by specifying the 'type' argument as "cor" and using the 'label'
argument to select the appropriate matrix by its denominator, e.g., for batch
correction method ComBat this would be "bat", for RemoveBatchEffects from the
limma package this is "rbe". Default correction method-labels are "ruv3",
"bmc","bat","rbe","pn","svd".

The combination of 'type' and 'label' argument basically accesses the
attribute 'cor', a list that stores all matrices of corrected counts.
This list can also be accessed via getter and setter methods. Hence, the user
can supply their own matrices with own names.
}
\examples{
# This will return the data.frame for plotting.
data(dummy.mbec)
data.RLE <- mbecRLE(input.obj=dummy.mbec, type="clr",
model.vars=c('group','batch'), return.data=TRUE)

# This will return the ggplot2 object for display, saving and modification.
plot.RLE <- mbecRLE(input.obj=dummy.mbec, model.vars=c('group','batch'),
type="clr", return.data=FALSE)
}
\keyword{RLE}
\keyword{expression}
\keyword{log}
\keyword{relative}
