% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_plots.R
\name{mbecRDAStatsPlot}
\alias{mbecRDAStatsPlot}
\title{Plot Proportion of Variance for pRDA}
\usage{
mbecRDAStatsPlot(rda.obj)
}
\arguments{
\item{rda.obj, }{list or single output of 'mbecVarianceStats' with method rda}
}
\value{
A ggplot2 box-plot object.
}
\description{
Covariate-Variances as modeled by pRDA will be displayed as box-plots.
It works with the output of 'mbecVarianceStats()' for the method 'rda'.
Format of this output is a data.frame that contains a column for every model
variable and as many rows as there are features (OTUs, Genes, ..). Multiple
frames may be used as input by putting them into a list - IF the data.frames
contain a column named 'type', this function will use 'facet_grid()' to
display side-by-side panels to enable easy comparison.
}
\examples{
# This will return a paneled plot that shows results for three variance
# assessments.
data(dummy.mbec)
df.var.rda <- mbecModelVariance(input.obj=dummy.mbec,
model.vars=c('group','batch'), method='rda', type='clr')
plot.rda <- mbecRDAStatsPlot(rda.obj=df.var.rda)
}
\keyword{Analysis}
\keyword{Redundancy}
\keyword{partial}
\keyword{plot}
\keyword{proportion}
\keyword{variance}
