% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_helper.R
\name{mbecHelpFactor}
\alias{mbecHelpFactor}
\title{Check If Covariates Are Factors}
\usage{
mbecHelpFactor(tmp.meta, model.vars)
}
\arguments{
\item{tmp.meta}{A covariate matrix to check.}

\item{model.vars}{Names of covariates to construct to check in tmp.meta.}
}
\value{
A covariate matrix with factorized variables.
}
\description{
For a given covariate matrix and a vector of factor names this function tests
if they are formatted as factors and re-formats them if required.
}
\examples{
# This will ensure that the covariates 'batch' and 'group' are factors.
data(dummy.list)
eval.obj <- mbecHelpFactor(tmp.meta=dummy.list$meta,
model.vars=c("group","batch"))
}
\keyword{Wrapper}
\keyword{limma}
\keyword{nonEstimable}
