% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_plots.R
\name{mbecHeatPlot}
\alias{mbecHeatPlot}
\title{Heatmap plotting function}
\usage{
mbecHeatPlot(tmp.cnts, tmp.meta, model.vars, label = NULL)
}
\arguments{
\item{tmp.cnts}{Count values of selected features.}

\item{tmp.meta}{Covariate information for potting.}

\item{model.vars}{Two covariates of interest to select by first variable
selects panels and second one determines coloring.}

\item{label}{Name of the plot displayed as legend title.}
}
\value{
ggplot2 object
}
\description{
Takes data.frame from 'mbecHeat()' and produces a ggplot2 object.
}
\examples{
# This will return a paneled plot that shows results for the variance
# assessment.
data(dummy.mbec)
heat.df <- mbecHeat(input.obj=dummy.mbec, model.vars=c('group','batch'),
center=TRUE, scale=TRUE, method='TOP', n=5, return.data=TRUE)
plot.heat <- mbecHeatPlot(tmp.cnts=heat.df[[1]],
tmp.meta=heat.df[[2]], model.vars=c('group','batch'))
}
\keyword{RLE}
\keyword{expression}
\keyword{log}
\keyword{relative}
