% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fluidigm-methods.R
\name{getConcordance}
\alias{getConcordance}
\alias{getwss}
\alias{getss}
\alias{getrc}
\title{Get the concordance between two experiments}
\usage{
getConcordance(
  singleCellRef,
  singleCellcomp,
  groups = NULL,
  fun.natural = expavg,
  fun.cycle = logmean
)

getwss(concord, nexp)

getss(concord)

getrc(concord)
}
\arguments{
\item{singleCellRef}{"reference" SingleCellAssay}

\item{singleCellcomp}{"comparison" SingleCellAssay}

\item{groups}{character vector giving variable(s) on which the comparison is conditioned}

\item{fun.natural}{function to transform the SingleCellAssays to a mRNA proportional level}

\item{fun.cycle}{inverse function of fun.natural}

\item{concord}{data.frame returned by getConcordance}

\item{nexp}{number of expressed cells per row in \code{concord}}
}
\value{
concordance between two assays
}
\description{
Return the concordance between two assays (i.e. single cell and hundred cell).
The "average" of \code{singleCellRef} (after adjusting for the number of cells) and
\code{singleCellComp} are taken per gene, per \code{groups}.
A \code{data.frame} with one row per gene-\code{groups} is returned with some additional columns.
}
\section{Functions}{
\itemize{
\item \code{getwss()}: getrc the sum of squares, weighted by nexp

\item \code{getss()}: return the sum of squares

\item \code{getrc()}: Return Lin's (1989) concordance correlation coefficient

}}
\examples{
data(vbetaFA)
sca1 <- subset(vbetaFA, ncells==1)
sca100 <- subset(vbetaFA, ncells==100)
concord <- getConcordance(sca1, sca100)
getss(concord)
getrc(concord)
}
\seealso{
\link{plotSCAConcordance}
}
\author{
Andrew McDavid
}
