% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/000.MapfxFFC.R
\name{MapfxFFC}
\alias{MapfxFFC}
\title{Normalising data from the Fluorescence Flow Cytometry (FFC) Experiments with mapfx.norm}
\usage{
MapfxFFC(
  runVignette = FALSE,
  runVignette_meta = NULL,
  runVignette_rawInten = NULL,
  FCSpath = NULL,
  Outpath = NULL,
  protein.v = NULL,
  protein.upper.quantile = 0.9,
  protein.lower.quantile = 0.1,
  protein.min.quantile = 0.01,
  plots.bkc.protein = TRUE,
  plots.initM = TRUE,
  plots.rmBatchEffect = TRUE,
  cluster.analysis.protein = TRUE,
  plots.cluster.analysis.protein = TRUE
)
}
\arguments{
\item{runVignette}{logical; if FALSE (default), specify a path to \code{FCSpath} argument; TRUE for running Vignette using built-in data.}

\item{runVignette_meta}{the argument for the built-in metadata when running Vignette; NULL (default).}

\item{runVignette_rawInten}{the argument for the built-in raw intensities when running Vignette; NULL (default).}

\item{FCSpath}{path to the input directory where \code{filename_meta.csv} and FCS files are stored. \code{filename_meta.csv} should be saved under \verb{FCSpath/FCS/meta/} and FCS files should be saved under \verb{FCSpath/FCS/fcs/}. See Vignette for details.}

\item{Outpath}{path to the output directory where intermediate results and final results will be stored.}

\item{protein.v}{a vector of the names of the protein markers (MUST be the same as the names in the FCS files). For example, \code{protein.v = c("FSC-H","FSC-W","SSC-H","SSC-W","CD3","CD4","CD8","CD45")}.}

\item{protein.upper.quantile}{the cut-off (default = 0.9) for selecting cells used for estimating the parameter of signal for protein markers.}

\item{protein.lower.quantile}{the cut-off (default = 0.1) for selecting cells used for estimating the parameters of noise for protein markers.}

\item{protein.min.quantile}{the cut-off (default = 0.01) for omitting the cells with the smallest values to minimise the impact of outliers during estimation.}

\item{plots.bkc.protein}{logical; if TRUE (default), produce scatter plots for pre- and post- background adjusted protein markers (calibrated values on y-axis and raw values on x-axis).}

\item{plots.initM}{logical; if TRUE (default), produce an UMAP embedding plot to visualise the structure of the biological clusters used to form the initial M matrix for removal of batch effects.}

\item{plots.rmBatchEffect}{logical; if TRUE (default), produce heatmaps to visualise the unwanted (batch) effects and biological effects in the pre- and post- adjusted datasets.}

\item{cluster.analysis.protein}{logical; if TRUE (default), perform cluster analysis using normalised protein markers.}

\item{plots.cluster.analysis.protein}{logical; if TRUE (default), produce an UMAP embedding plot from the normalised protein markers to visualise the structure of the biological clusters.}
}
\value{
Normalised protein markers on log scale and metadata for cells
}
\description{
This function is used to normalise, including background correction and removal of batch effects, protein intensity data from FFC assays. The input data is in FCS format. The functions include data normalisation and cluster analysis.
}
\details{
In the output directory, this function produces the normalised protein measurements, cell group labels from the cluster analysis using normalised proteins, and graphs will be provided if specified.
}
\examples{
# import built-in data
data(ord.fcs.raw.meta.df.out_ffc)
data(ord.fcs.raw.mt_ffc)

# create an Output directory for the MapfxFFC function
dir.create(file.path(tempdir(), "FFCnorm_Output"))

MapfxFFC_obj <- MapfxFFC(
  runVignette = TRUE, #set FALSE if not running this example
  runVignette_meta = ord.fcs.raw.meta.df.out_ffc, #set NULL if not running this example
  runVignette_rawInten = ord.fcs.raw.mt_ffc, #set NULL if not running this example
  FCSpath = NULL, # users specify their own input path if not running this example
  Outpath = file.path(tempdir(), "FFCnorm_Output"),
  protein.v = c("CD3","CD4","CD8","CD45"),
  protein.upper.quantile = 0.9, 
  protein.lower.quantile = 0.1, 
  protein.min.quantile = 0.01,
  plots.bkc.protein = TRUE,
  plots.initM = TRUE,
  plots.rmBatchEffect = TRUE,
  cluster.analysis.protein = TRUE, plots.cluster.analysis.protein = TRUE)
  

}
\author{
Hsiao-Chi Liao, Agus Salim
}
