\docType{data}
\name{L1_DRG_20_example.loom}
\alias{L1_DRG_20_example.loom}
\alias{L1_DRG_20_example}
\title{L1_DRG_20_example.loom}
\format{An hdf5 file in the Loom format}
\description{
An example \code{hdf5} file in the Loom file format obtained from the Linnarson
Lab.

The original file was imported using \code{LoomExperiment} and truncated using
the package's subsetting methods. The purpose of this truncation was to reduce
the total size of the data as the file's purpose is simply to
demonstrate \code{LoomExperiment}'s functionality.

The data set has dimensions of 20x20. The file contains 7 \code{rowData} and 103
\code{colData} entries each corresponding to readings generated by
high-throughput sequencing experiments. In addition, a \code{colGraphs} entry
encoding a\code{LoomGraph} containing two \code{LoomGraph} objects are also
included.
}

\examples{
## Load L1_DRG_20_example.loom using LoomExperiment's import() method
l1_file <- system.file("extdata", "L1_DRG_20_example.loom", package = "LoomExperiment")
scle <- import(l1_file, type="SingleCellLoomExperiment")
scle
}

\keyword{datasets}
