% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Linnorm.limma.R
\name{Linnorm.limma}
\alias{Linnorm.limma}
\title{Linnorm-limma pipeline for Differentially Expression Analysis}
\usage{
Linnorm.limma(
  datamatrix,
  design = NULL,
  RowSamples = FALSE,
  MZP = 0,
  output = "DEResults",
  noINF = TRUE,
  robust = FALSE,
  ...
)
}
\arguments{
\item{datamatrix}{The matrix or data frame that contains your dataset. Raw Counts, CPM, RPKM, FPKM or TPM are supported. Undefined values such as NA are not supported. It is not compatible with log transformed datasets.}

\item{design}{A design matrix required for limma. Please see limma's documentation or our vignettes for more detail.}

\item{RowSamples}{Logical. In the datamatrix, if each row is a sample and each column is a feature, set this to TRUE so that you don't need to transpose it. Linnorm works slightly faster with this argument set to TRUE, but it should be negligable for smaller datasets. Defaults to FALSE.}

\item{MZP}{Double >=0, <= 1. Minimum non-Zero Portion Threshold for this function. Genes not satisfying this threshold will be removed from HVG anlaysis. For exmaple, if set to 0.3, genes without at least 30 percent of the samples being non-zero will be removed. Defaults to 0.}

\item{output}{Character. "DEResults" or "Both". Set to "DEResults" to output a matrix that contains Differential Expression Analysis Results. Set to "Both" to output a list that contains both Differential Expression Analysis Results and the transformed data matrix.}

\item{noINF}{Logical. Prevent generating INF in the fold change column by adding the estimated count of one. If it is set to FALSE, zero or INF will be generated if one of the conditions has zero expression. Defaults to TRUE.}

\item{robust}{Logical. In the eBayes function of Limma, run with robust setting with TRUE or FALSE. Defaults to FALSE.}

\item{...}{arguments that will be passed into Linnorm's transformation function.}
}
\value{
If output is set to "DEResults", this function will output a matrix with Differntial Expression Analysis Results with the following columns:
\itemize{
 \item{logFC:}{ Log 2 Fold Change}
 \item{XPM:}{ Average Expression. If input is raw count or CPM, this column has the CPM unit. If input is RPKM, FPKM or TPM, this column has the TPM unit.}
 \item{t:}{ moderated t-statistic}
 \item{P.Value:}{ p value}
 \item{adj.P.Val:}{ Adjusted p value. This is also called False Discovery Rate or q value.}
 \item{B:}{ log odds that the feature is differential}
}

If output is set to Both, this function will output a list with the following objects:
\itemize{
 \item{DEResults:}{ Differntial Expression Analysis Results as described above.}
 \item{Linnorm:}{ Linnorm transformed data matrix.}
}
}
\description{
This function first performs Linnorm transformation on the dataset. Then, it will perform limma for DEG analysis. Please cite both Linnorm and limma when you use this function for publications.
}
\details{
This function performs both Linnorm and limma for users who are interested in differential expression analysis.
}
\examples{
#Obtain example matrix:
data(LIHC)
#Create limma design matrix (first 5 columns are tumor, last 5 columns are normal)
designmatrix <- c(rep(1,5),rep(2,5))
designmatrix <- model.matrix(~ 0+factor(designmatrix))
colnames(designmatrix) <- c("group1", "group2")
rownames(designmatrix) <- colnames(LIHC)
#DEG analysis
DEGResults <- Linnorm.limma(LIHC, designmatrix)
}
\keyword{CPM}
\keyword{Count}
\keyword{Expression}
\keyword{FPKM}
\keyword{Linnorm}
\keyword{Parametric}
\keyword{RNA-seq}
\keyword{RPKM}
\keyword{Raw}
\keyword{TPM}
\keyword{limma}
\keyword{normalization}
\keyword{transformation}
