% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Linnorm.R
\name{Linnorm}
\alias{Linnorm}
\title{Linnorm Normalizing Transformation Function}
\usage{
Linnorm(
  datamatrix,
  RowSamples = FALSE,
  spikein = NULL,
  spikein_log2FC = NULL,
  showinfo = FALSE,
  perturbation = "Auto",
  Filter = FALSE,
  minNonZeroPortion = 0.75,
  L_F_p = 0.3173,
  L_F_LC_Genes = "Auto",
  L_F_HC_Genes = 0.01,
  BE_F_p = 0.3173,
  BE_F_LC_Genes = "Auto",
  BE_F_HC_Genes = 0.01,
  BE_strength = 0.5,
  max_F_LC = 0.75,
  DataImputation = FALSE,
  ...
)
}
\arguments{
\item{datamatrix}{The matrix or data frame that contains your dataset. Raw Counts, CPM, RPKM, FPKM or TPM are supported. Undefined values such as NA are not supported. It is not compatible with log transformed datasets.}

\item{RowSamples}{Logical. In the datamatrix, if each row is a sample and each column is a feature, set this to TRUE so that you don't need to transpose it. Linnorm works slightly faster with this argument set to FALSE, but it should be negligable for smaller datasets. Defaults to FALSE.}

\item{spikein}{character vector. Names of the spike-in genes in the datamatrix. Defaults to NULL.}

\item{spikein_log2FC}{Numeric vector. Log 2 fold change of the spike-in genes. Defaults to NULL.}

\item{showinfo}{Logical. Show algorithm running information. Defaults to FALSE.}

\item{perturbation}{Integer >=2 or "Auto". To search for an optimal minimal deviation parameter (please see the article), Linnorm uses the iterated local search algorithm which perturbs away from the initial local minimum. The range of the area searched in each perturbation is exponentially increased as the area get further away from the initial local minimum, which is determined by their index. This range is calculated by 10 * (perturbation ^ index). Defaults to "Auto".}

\item{Filter}{Logical. Should Linnorm filter the dataset in the end results? Defaults to FALSE.}

\item{minNonZeroPortion}{Double >= 0.01, <= 0.95. Minimum non-Zero Portion Threshold. Genes not satisfying this threshold will be removed. For exmaple, if set to 0.75, genes without at least 75 percent of the samples being non-zero will be removed. Defaults to 0.75.}

\item{L_F_p}{Double >= 0, <= 1. Filter genes with standard deviation and skewness less than this p value before applying Linnorm algorithm. Defaults to 0.3173.}

\item{L_F_LC_Genes}{Double >= 0.01, <= 0.95 or Character "Auto". Filter this portion of the lowest expressing genes before applying Linnorm algorithm. It can be determined automatically by setting to "Auto". Defaults to "Auto".}

\item{L_F_HC_Genes}{Double >= 0.01, <= 0.95. Filter this portion of the highest expressing genes before applying Linnorm algorithm. Defaults to 0.01.}

\item{BE_F_p}{Double >=0, <= 1. Filter genes with standard deviation and skewness less than this p value before applying Linnorm's batch effect normalization algorithm. Defaults to 0.3173.}

\item{BE_F_LC_Genes}{Double >= 0.01, <= 0.95 or Character "Auto". Filter this portion of the lowest expressing genes before applying Linnorm's batch effect normalization algorithm. It can be determined automatically by setting to "Auto". Defaults to "Auto".}

\item{BE_F_HC_Genes}{Double >= 0.01, <= 0.95. Filter this portion of the highest expressing genes before applying Linnorm's batch effect normalization algorithm. Defaults to 0.01.}

\item{BE_strength}{Double >0, <= 1. Before Linnorm transformation, how strongly should Linnorm normalize batch effects? Defaults to 0.5.}

\item{max_F_LC}{Double >=0, <= 0.95. When L_F_LC or B_F_LC is set to auto, this is the maximum threshold that Linnorm would assign. Defaults to 0.75.}

\item{DataImputation}{Logical. Perform data imputation on the dataset after transformation. Defaults to FALSE.}

\item{...}{place holder for any new arguments.}
}
\value{
This function returns a transformed data matrix.

If Filter is set to True, this function will output a list with the following objects:
\itemize{
 \item{Linnorm:}{ The full non-filtered transformed data matrix. }
 \item{Keep_Features:}{ The features that survived filtering, users may use it to filter the data. }
}
}
\description{
This function performs the Linear model and normality based transformation method (Linnorm) for (sc)RNA-seq expression data or large scale count data.
}
\details{
This function normalizes and transforms the input dataset using the Linnorm algorithm.
}
\examples{
#Obtain example matrix:
data(LIHC)
#Transformation:
transformedExp <- Linnorm(LIHC)
}
\keyword{CPM}
\keyword{Count}
\keyword{Expression}
\keyword{FPKM}
\keyword{Linnorm}
\keyword{Parametric}
\keyword{RNA-seq}
\keyword{RPKM}
\keyword{Raw}
\keyword{TPM}
\keyword{normalization}
\keyword{transformation}
