% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Linnorm.Norm.R
\name{Linnorm.Norm}
\alias{Linnorm.Norm}
\title{Linnorm Normalization Function}
\usage{
Linnorm.Norm(
  datamatrix,
  RowSamples = FALSE,
  spikein = NULL,
  spikein_log2FC = NULL,
  showinfo = FALSE,
  output = "XPM",
  minNonZeroPortion = 0.3,
  BE_F_p = 0.3173,
  BE_F_LC_Genes = "Auto",
  BE_F_HC_Genes = 0.01,
  BE_strength = 0.5,
  max_F_LC = 0.75
)
}
\arguments{
\item{datamatrix}{The matrix or data frame that contains your dataset. Raw Counts, CPM, RPKM, FPKM or TPM are supported. Undefined values such as NA are not supported. It is not compatible with log transformed datasets.}

\item{RowSamples}{Logical. In the datamatrix, if each row is a sample and each column is a feature, set this to TRUE so that you don't need to transpose it. Linnorm works slightly faster with this argument set to TRUE, but it should be negligable for smaller datasets. Defaults to FALSE.}

\item{spikein}{character vector. Names of the spike-in genes in the datamatrix. Defaults to NULL.}

\item{spikein_log2FC}{Numeric vector. Log 2 fold change of the spike-in genes. Defaults to NULL.}

\item{showinfo}{Logical. Show algorithm running information. Defaults to FALSE.}

\item{output}{character. "Raw" or "XPM". Output's total count will be approximately the median of the inputs' when set to "Raw". Output CPM (if input is raw counts or CPM) or TPM (if input is RPKM FPKM or TPM) when set to "XPM".}

\item{minNonZeroPortion}{Double >=0, <= 1. Minimum non-Zero Portion Threshold. Genes not satisfying this threshold will be removed. For exmaple, if set to 0.75, genes without at least 75 percent of the samples being non-zero will be removed. Defaults to 0.75.}

\item{BE_F_p}{Double >=0, <= 1. Filter genes with standard deviation and skewness less than this p value before applying Linnorm's batch effect normalization algorithm. Defaults to 0.3173.}

\item{BE_F_LC_Genes}{Double >= 0.01, <= 0.95 or Character "Auto". Filter this portion of the lowest expressing genes before applying Linnorm's batch effect normalization algorithm. It can be determined automatically by setting to "Auto". Defaults to "Auto".}

\item{BE_F_HC_Genes}{Double >=0, <= 1. Filter this portion of the highest expressing genes before applying Linnorm's batch effect normalization algorithm. Defaults to 0.01.}

\item{BE_strength}{Double >0, <= 1. How strongly should Linnorm normalize batch effects? Defaults to 0.5.}

\item{max_F_LC}{Double >=0, <= 0.95. When L_F_LC or B_F_LC is set to auto, this is the maximum threshold that Linnorm would assign. Defaults to 0.75.}
}
\value{
This function returns a normalized data matrix.
}
\description{
This function performs batch effect and library size difference normalization on the input dataset.
}
\details{
This function normalizes the input dataset using the Linnorm algorithm.
}
\examples{
#Obtain example matrix:
data(LIHC)
#Normalization:
normalizedExp <- Linnorm(LIHC)
}
\keyword{CPM}
\keyword{Count}
\keyword{Expression}
\keyword{FPKM}
\keyword{Linnorm}
\keyword{RNA-seq}
\keyword{RPKM}
\keyword{Raw}
\keyword{TPM}
\keyword{normalization}
