% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Linnorm.HVar.R
\name{Linnorm.HVar}
\alias{Linnorm.HVar}
\title{Linnorm-Hvar pipeline for highly variable gene discovery.}
\usage{
Linnorm.HVar(
  datamatrix,
  RowSamples = FALSE,
  spikein = NULL,
  spikein_log2FC = NULL,
  log.p = FALSE,
  sig.value = "p",
  sig = 0.05,
  MZP = 0.25,
  FG_Recov = 0.5,
  plot.title = "Mean vs SD plot",
  ...
)
}
\arguments{
\item{datamatrix}{The matrix or data frame that contains your dataset. Raw Counts, CPM, RPKM, FPKM or TPM are supported. Undefined values such as NA are not supported. It is not compatible with log transformed datasets.}

\item{RowSamples}{Logical. In the datamatrix, if each row is a sample and each column is a feature, set this to TRUE so that you don't need to transpose it. Linnorm works slightly faster with this argument set to TRUE, but it should be negligable for smaller datasets. Defaults to FALSE.}

\item{spikein}{character vector. Names of the spike-in genes in the datamatrix. Defaults to NULL.}

\item{spikein_log2FC}{Numeric vector. Log 2 fold change of the spike-in genes. Defaults to NULL.}

\item{log.p}{Logical. Output p/q values in log scale. Defaults to FALSE.}

\item{sig.value}{Character. "p" or "q". Use p or q value for highlighting significant genes. Defaults to "p".}

\item{sig}{Double >0, <= 1. Significant level of p or q value for plotting. Defaults to 0.05.}

\item{MZP}{Double >=0, <= 1. Minimum non-Zero Portion Threshold for this function. Genes not satisfying this threshold will be removed from HVG anlaysis. For exmaple, if set to 0.3, genes without at least 30 percent of the samples being non-zero will be removed. Defaults to 0.25.}

\item{FG_Recov}{Double >=0, <= 1. In the low count gene filtering algorithm, recover this portion of genes that are filtered. Defaults to 0.5.}

\item{plot.title}{Character. The plot's title. Defaults to "Mean vs SD plot".}

\item{...}{arguments that will be passed into Linnorm's transformation function.}
}
\value{
This function will output a list with the following objects:
\itemize{
 \item{Results:}{ A matrix with the results.}
 \item{plot:}{ Mean vs Standard Deviation Plot which highlights significant genes.}
 \item{Linnorm:}{ Linnorm transformed data matrix.}
}

The Results matrix has the following columns:
\itemize{
 \item{Transformed.Avg.Exp:}{ Average expression of non-zero Linnorm transformed data.}
 \item{Transformed.SD:}{ Standard deviation of non-zero Linnorm transformed data.}
 \item{Normalized.Log2.SD.Fold.Change:}{ Normalized log2 fold change of the gene's standard deviation.}
 \item{p.value:}{ p value of the statistical test.}
 \item{q.value:}{ q value/false discovery rate/adjusted p value of the statistical test.}
}
}
\description{
This function first performs Linnorm transformation on the dataset. Then, it will perform highly variable gene discovery.
}
\details{
This function discovers highly variable gene in the dataset using Linnorm transformation.
}
\examples{
data(Islam2011)
results <- Linnorm.HVar(Islam2011)
}
\keyword{CPM}
\keyword{Count}
\keyword{Expression}
\keyword{FPKM}
\keyword{Linnorm}
\keyword{Parametric}
\keyword{RNA-seq}
\keyword{RPKM}
\keyword{Raw}
\keyword{TPM}
\keyword{highly}
\keyword{normalization}
\keyword{transformation}
\keyword{variable}
\keyword{variance}
