% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarSelection-Class.R
\docType{methods}
\name{Variables}
\alias{Variables}
\alias{Variables,VarSelection-method}
\title{Variables}
\usage{
\S4method{Variables}{VarSelection}(x)
}
\arguments{
\item{x}{an object from VarSelection class.}
}
\value{
Variables list of selected variables from VarSelection object
}
\description{
Accessor to selected Variables from VarSelection output.
}
\examples{
{
data(Taraoceans)
pro.phylo <- Taraoceans$taxonomy[ ,'Phylum']
TaraOc<-list(Taraoceans$phychem,as.data.frame(Taraoceans$pro.phylo),
as.data.frame(Taraoceans$pro.NOGs))
TaraOc_1<-scale(TaraOc[[1]])
Normalization<-lapply(list(TaraOc[[2]],TaraOc[[3]]),
function(x){DataProcessing(x,Method='Compositional')})
colnames(Normalization[[1]])=pro.phylo
colnames(Normalization[[2]])=Taraoceans$GO
TaraOc<-list(TaraOc_1,Normalization[[1]],Normalization[[2]])
names(TaraOc)<-c('phychem','pro_phylo','pro_NOGs')
TaraOc<-lapply(TaraOc,as.data.frame)
Output<-LinkData(TaraOc,Scale =FALSE,
Distance = c('ScalarProduct','Euclidean','Euclidean'))
Selection<-VarSelection(Output,TaraOc,Crit='Rsquare',perc=0.95)
Variables(Selection)
}
}
