% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarSelection-Class.R
\docType{methods}
\name{VarTable}
\alias{VarTable}
\alias{VarTable,VarSelection-method}
\title{VarTable}
\usage{
\S4method{VarTable}{VarSelection}(x)
}
\arguments{
\item{x}{an object from VarSelection class.}
}
\value{
VarTable data.frame with the name of input tables in
the LinkData function
}
\description{
Accessor to Table with the selected variables from VarSelection output.
}
\examples{
{
data(Taraoceans)
pro.phylo <- Taraoceans$taxonomy[ ,'Phylum']
TaraOc<-list(Taraoceans$phychem,as.data.frame(Taraoceans$pro.phylo),
as.data.frame(Taraoceans$pro.NOGs))
TaraOc_1<-scale(TaraOc[[1]])
Normalization<-lapply(list(TaraOc[[2]],TaraOc[[3]]),
function(x){DataProcessing(x,Method='Compositional')})
colnames(Normalization[[1]])=pro.phylo
colnames(Normalization[[2]])=Taraoceans$GO
TaraOc<-list(TaraOc_1,Normalization[[1]],Normalization[[2]])
names(TaraOc)<-c('phychem','pro_phylo','pro_NOGs')
TaraOc<-lapply(TaraOc,as.data.frame)
Output<-LinkData(TaraOc,Scale =FALSE,
Distance = c('ScalarProduct','Euclidean','Euclidean'))
Selection<-VarSelection(Output,TaraOc,Crit='Rsquare',perc=0.95)
VarTable(Selection)
}
}
