% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompromisePlot.R
\docType{methods}
\name{CompromisePlot}
\alias{CompromisePlot}
\alias{CompromisePlot,DistStatis-method}
\title{Compromise-Plot}
\usage{
\S4method{CompromisePlot}{DistStatis}(x,x_lab=NULL, y_lab=NULL,
Name=NULL, pchPoints=2, colObs=NULL,...)
}
\arguments{
\item{x}{DistStatis class object.}

\item{x_lab}{a character indicating x_label. Default is x.}

\item{y_lab}{a character indicating y_label. Default is y.}

\item{Name}{a character indicating plot title.}

\item{pchPoints}{pch for points in scatter plot.}

\item{colObs}{is a  character indicating the color for the observations. By Default is the QR (indicating the Quality of Representation of observations)}

\item{...}{additional parameters from ggplot2 library}
}
\value{
plotted CompromisePlot/s of the component/s of the given DistStatis object.
}
\description{
Plot a \code{CompromisePlot} of a DiStatis object
}
\examples{
{

data(Taraoceans)
pro.phylo <- Taraoceans$taxonomy[ ,'Phylum']
TaraOc<-list(Taraoceans$phychem,as.data.frame(Taraoceans$pro.phylo),
as.data.frame(Taraoceans$pro.NOGs))
TaraOc_1<-scale(TaraOc[[1]])
Normalization<-lapply(list(TaraOc[[2]],TaraOc[[3]]),
function(x){DataProcessing(x,Method='Compositional')})
colnames(Normalization[[1]])=pro.phylo
colnames(Normalization[[2]])=Taraoceans$GO
TaraOc<-list(TaraOc_1,Normalization[[1]],Normalization[[2]])
names(TaraOc)<-c('phychem','pro_phylo','pro_NOGs')
TaraOc<-lapply(TaraOc,as.data.frame)
Output<-LinkData(TaraOc,Scale =FALSE,Distance = c('ScalarProduct','Euclidean','Euclidean'))
CompromisePlot(Output) +
theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
panel.background = element_blank(), axis.line = element_line(colour = 'black'))


}
}
\author{
Laura M. Zingaretti
}
