% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGenesAnnotation.R
\name{getGenesAnnotation}
\alias{getGenesAnnotation}
\title{getGenesAnnotation returns the required information about a list of genes from Ensembl biomart.}
\usage{
getGenesAnnotation(
  values,
  attributes = c("ensembl_gene_id", "external_gene_name", "percentage_gene_gc_content",
    "entrezgene_id"),
  filter = "ensembl_gene_id",
  notHSapiens = FALSE,
  notHumandataset = "",
  referenceGenome = 38
)
}
\arguments{
\item{values}{A list of genes that contains the names or IDs or "allGenome" string, which indicates that all genome will be  returned.}

\item{attributes}{A vector which contains the different information attributes that the Ensembl biomart admit.}

\item{filter}{The attribute used as filter to return the rest of the attributes.}

\item{notHSapiens}{A boolean value that indicates if the user wants the human annotation or another annotation available in BiomaRt. The possible not human dataset can be consulted by calling the following function: biomaRt::listDatasets(useMart("ensembl")).}

\item{notHumandataset}{A dataset identification from biomaRt::listDatasets(useMart("ensembl")).}

\item{referenceGenome}{Integer that indicates used reference genome. It must be 37 or 38.}
}
\value{
A matrix that contains all the information asked to the attributes parameter.
}
\description{
The function returns the required information about a list of genes from Ensembl biomart. This list of genes can be Ensembl ID, gene names or either of the possible values admited by Ensembl biomart. Furthermore, the reference genome can be chosen depending on the necessity of the user.
}
\examples{
myAnnotation <- getGenesAnnotation(c("KRT19","BRCA1"), filter="external_gene_name",notHSapiens=FALSE)
}
