% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEGsToDiseases.R
\name{DEGsToDiseases}
\alias{DEGsToDiseases}
\title{DEGsToDiseases obtains the information about what diseases are related to the DEGs indicated by parameter.}
\usage{
DEGsToDiseases(geneList, size = 10, disease = "", getEvidences = FALSE)
}
\arguments{
\item{geneList}{A list that contains the gene symbols or gene names of the DEGs.}

\item{size}{The number of diseases to retrieve from targetValidation}

\item{disease}{Query a specific disease instead of retrieving the whole list of related diseases.}

\item{getEvidences}{Boolean. If true, for each gene, a list of found evidences for each disease will be returned.}
}
\value{
A list which contains the information about the diseases associated to each genes or to a set of genes. If getEvidences is TRUE, found evidences for each case will be returned too.
}
\description{
The function obtains the information about what diseases are related to the DEGs indicated by parameter. For that, the function makes use of the web platforms gene2Diseases and targetValidation.
}
\examples{
diseases <- DEGsToDiseases(c("KRT19","BRCA1"), getEvidences = FALSE)
}
