% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEGsEvidences.R
\name{DEGsEvidences}
\alias{DEGsEvidences}
\title{DEGsEvidences function returns for each DEG a list of evidences that correlate it with the studied disease.}
\usage{
DEGsEvidences(geneList, disease, size = 10, verbose = TRUE)
}
\arguments{
\item{geneList}{A list that contains the gene symbols or gene names of the DEGs.}

\item{disease}{The name of a disease in order to obtain related evidences from target validation by using the DEGs indicated in the geneList parameter.}

\item{size}{The number of diseases to retrieve from targetValidation}

\item{verbose}{Boolean that indicates if progress messages are printed to stdout}
}
\value{
A list which names are genes from geneList and which contains related evidences for each gene in geneList and indicated disease.
}
\description{
DEGsEvidences function returns for each DEG a list of evidences that correlate it with the studied disease.
}
\examples{
evidences <- DEGsEvidences(c("KRT19","BRCA1","TYMP"),'cancer')
}
