% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refine_mappings.R
\name{refine_mappings}
\alias{refine_mappings}
\title{Refine pathway by cell type}
\usage{
refine_mappings(KEGG_mappings, cell_line)
}
\arguments{
\item{KEGG_mappings}{The data.frame object generated by the function 
expand_KEGG_mappings}

\item{cell_line}{Choose from the set of cell lines with baseline data; 
cell-lines may or may not have corresponding KO data}
}
\value{
A dataframe object with reduced set of pathway mappings to be
 passed on to other functions
}
\description{
Reduce the KEGG pathway by only including genes that are 
expressed within a given cell type
}
\examples{
p53_KGML <- get_KGML("hsa04115")
p53_KEGG_mappings <-  expand_KEGG_mappings(p53_KGML)
MCF7_p53_mappings <- refine_mappings(p53_KEGG_mappings, "MCF7")
}
