% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keggerize_edges.R
\name{keggerize_edges}
\alias{keggerize_edges}
\title{Add in edges to map documented in other pathways}
\usage{
keggerize_edges(entry_accession, KGML, KEGG_mappings, edges)
}
\arguments{
\item{entry_accession}{The Accession # of the pathway entity to 'keggerize'}

\item{KGML}{The KGML file of the current pathway}

\item{KEGG_mappings}{KEGG mappings for the current pathway}

\item{edges}{The expanded edges for the current pathway}
}
\value{
A modified expanded edges data frame with additional rows for new 
entries
}
\description{
For a specific pathway entity(gene), search KEGG databases
to see if it has any other documented relationships in KEGG.
expand_KEGG_edges
}
\examples{
\dontrun{
KGML <- get_KGML("hsa04150")
KEGG_mappings <- expand_KEGG_mappings(KGML)
edges <- expand_KEGG_edges(KGML, KEGG_mappings)
entry_accession <- "2475"
mtor_plus_mtor <- keggerize_edges(entry_accession = entry_accession, 
                                  KGML = KGML,KEGG_mappings = KEGG_mappings,
                                  edges = edges) }

}
