% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net_dist_bin.R
\name{net_dist_bin}
\alias{net_dist_bin}
\title{Function to calculate the distance between nodes.}
\usage{
net_dist_bin(GRN, TFs, thr)
}
\arguments{
\item{GRN}{An inferred networks with the predictive probabilities that a transcription factor regulates a gene.}

\item{TFs}{A vector with indexes of the rows of GRN which correspond to TFs.}

\item{thr}{A scalar between 0 and 1 that is used select the edges with large posterior probabilities.}
}
\value{
a matrix with the distances between edges.
}
\description{
Function to calculate the distance between nodes.
}
\examples{
data(D4_multi_1)
Net = kboost(D4_multi_1)
dist = net_dist_bin(Net$GRN,Net$TFs,0.1)

}
