% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KBoost_human_symbol.R
\name{KBoost_human_symbol}
\alias{KBoost_human_symbol}
\title{Function for KBoost on data from a human sample annotated with Symbol names.}
\usage{
KBoost_human_symbol(X, gen_names, g, v, ite, pos_weight, neg_weight)
}
\arguments{
\item{X}{an NxG matrix with the expression values of G genes and N samples.}

\item{gen_names}{SYMBOL gene names corresponding to the columns of X.}

\item{g}{a positive no., width parameter for the RBF kernel. (default g = 40)}

\item{v}{a double between 0 and 1, the shrinkage parameter. (default v =0.1)}

\item{ite}{an integer with the number of iterations (default ite = 3)}

\item{pos_weight}{no. between 0 and 1. Prior that a TF regulate a gene.}

\item{neg_weight}{no. between 0 and 1, for TF gene pairs not seen before.}
}
\value{
list with results of KBoost on a dataset with Symbol gene names.
}
\description{
Function for KBoost on data from a human sample annotated with Symbol names.
}
\examples{
X = rnorm(50,0,1)
X = matrix(X,10,5)
gen_names = c("TP53","YY1","CTCF","MDM2","ESR1")
grn = KBoost_human_symbol(X,gen_names,pos_weight = 0.6, neg_weight =0.4)
}
