% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterGeneExpr.R
\name{filterGeneExpr}
\alias{filterGeneExpr}
\title{Function to filter gene expression}
\usage{
filterGeneExpr(obj, cutVal = 0, geneType = NA, checkExprDistr = FALSE,
  plotExprDistr = FALSE)
}
\arguments{
\item{obj}{InTADSig object}

\item{cutVal}{Exclude genes that have max expression less or equal to
this value in all samples. Default: 0}

\item{geneType}{Type of gene to select for filtering i.e. "protein_coding".
Default:NA}

\item{checkExprDistr}{Adjust cutVal based on gene expression distribution}

\item{plotExprDistr}{Perform visualziation of the distribution}
}
\value{
InTADSig object with filtered counts table
}
\description{
This function performs filtering of gene expression counts based on various
 parameters
}
\details{
The function allows to stabilize the functional activity of the genes. By
default all not expressed genes are filtered. It is also possible to set type
of gene to take into account i.e. "protein_coding" only. This option requires
additional metadata column "transcript_type".
Also, special filtering option based on mclust library allows to analyze
distribution of counts and adjust the cut value to exclude low expressed
genes.
}
\examples{
## perform analysis on test data
inTadSig <- newSigInTAD(enhSel, enhSelGR, rpkmCountsSel, txsSel)
## default filtering
inTadSig <- filterGeneExpr(inTadSig)
## filter based on gene type
inTadSig <- filterGeneExpr(inTadSig, geneType = "protein_coding")


}
