% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09.get_zScoreCutoff.R
\name{get_zScoreCutoff}
\alias{get_zScoreCutoff}
\title{Calculate local background cutoff value}
\usage{
get_zScoreCutoff(
  background,
  chr.introns,
  chr.totalCov,
  chr.utr3,
  seqname,
  z = 2
)
}
\arguments{
\item{background}{A character(1) vector, indicating how background coverage
is defined.}

\item{chr.introns}{An object of \link[GenomicRanges:GRanges-class]{GenomicRanges::GRanges} for introns
of a give chromosome/scaffold}

\item{chr.totalCov}{total coverage for a given chromosome/scaffold, an output
from \code{\link[=get_totalCov]{get_totalCov()}} for a given chromosome/scaffold}

\item{chr.utr3}{An object of \link[GenomicRanges:GRanges-class]{GenomicRanges::GRanges}, an element of
the output of \code{\link[=extract_UTR3Anno]{extract_UTR3Anno()}} for a given chromosome/scaffold}

\item{seqname}{A character(1), the name of a chromosome/scaffold}

\item{z}{Z score cutoff value}
}
\value{
A named numeric vector containing local background Z-score cutoff
values. The names are GRanges's name for 3' UTRs.
}
\description{
calculate local background z-score cutoff
}
\author{
Jianhong Ou, Haibo Liu
}
\keyword{internal}
