% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotChromValuePair.R
\name{plotChromValuePair}
\alias{plotChromValuePair}
\title{Base function which plots the ideogram and superimposed data for a single chromosome. plotOnIdeo() calls this function and stacks the resulting output.}
\usage{
plotChromValuePair(chrom, cytoTable, bpLim, vertical, 
values_GR,val_range, col, value_cols = "values", default_margins, 
addScale, ablines_y, smoothVals, span=0.03, verbose = FALSE, ...)
}
\arguments{
\item{...}{arguments to \code{axis()}, \code{line()}, and 
\code{rect()}}

\item{chrom(character)}{chromosome(s) to create ideograms for}

\item{cytoTable(data.frame)}{loaded ideogram table. 
(see ideoTable argument to plotOnIdeo())}

\item{bpLim(numeric)}{(aka xlim); display only a section of the 
chromosome and the corresponding values}

\item{vertical(logical)}{if TRUE, chromosomes will be plotted 
vertically}

\item{values_GR(list}{or GenomicRanges) If plotType is "lines" or
"rect", the function expects this to be a GRanges() object with 
data series in metadata columns. 
If plotType is "seg_tracks" this is a list of GRanges(), each 
entry of which represents a track.}

\item{val_range(numeric)}{(aka ylim); y-axis scale for data series}

\item{col(character)}{colour for series}

\item{value_cols(character)}{column name for series to plot}

\item{default_margins(numeric)}{page inner margins (in inches)}

\item{addScale(logical)}{if FALSE, bp positions will be hidden}

\item{ablines_y(numeric)}{when specified, will draw reference lines 
on the y-axis}

\item{smoothVals(logical)}{when T applies loess() to each series}

\item{span(numeric)}{loess::span()}

\item{verbose(logical)}{print messages}
}
\description{
Base function which plots the ideogram and superimposed data for a single chromosome. plotOnIdeo() calls this function and stacks the resulting output.
}
\details{
Plots one unit of chromosome ideogram with dataseries 
superimposed. Usually, the user can avoid this function and directly
call plotOnIdeo(). However, this function may be used in 
cases where further plot customization is required.
}
\examples{
data(hg18_ideo)
data(binned_multiSeries)
layout(matrix(1:2, byrow=TRUE,ncol=1),heights=c(2.5,1))
plotChromValuePair("chr1",hg18_ideo, 
	values_GR=binned_multiSeries,
value_cols=colnames(mcols(binned_multiSeries)),plotType='lines',
	col=1:5,val_range=c(0,10),bpLim=NULL,vertical=FALSE,addScale=TRUE,
ablines_y=NULL,smoothVals=FALSE,default_margins=c(0.5,.5,.1,.1))
}
\seealso{
plotOnIdeo()
}
