% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis-functions.R
\name{threshold_filter}
\alias{threshold_filter}
\title{Filter data frames with custom predicates}
\usage{
threshold_filter(x, threshold, cols_to_compare = "Value", comparators = ">")
}
\arguments{
\item{x}{A data frame or a list of data frames}

\item{threshold}{A numeric/integer vector or a named list of
numeric/integer vectors}

\item{cols_to_compare}{A character vector or a named list of
character vectors}

\item{comparators}{A character vector or a named list of
character vectors. Must be one of the allowed values between
\code{c("<", ">", "==", "!=", ">=", "<=")}}
}
\value{
A data frame or a list of data frames
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
This function is deprecated and it's likely going to be dropped in the
next release cycle.

Filter a single data frame or a list of data frames with custom
predicates assembled from the function parameters.
}
\examples{
\dontrun{
example_df <- tibble::tibble(
    a = c(20, 30, 40),
    b = c(40, 50, 60),
    c = c("a", "b", "c"),
    d = c(3L, 4L, 5L)
)
example_list <- list(
    first = example_df,
    second = example_df,
    third = example_df
)

filtered <- threshold_filter(example_list,
    threshold = list(
        first = c(20, 60),
        third = c(25)
    ),
    cols_to_compare = list(
        first = c("a", "b"),
        third = c("a")
    ),
    comparators = list(
        first = c(">", "<"),
        third = c(">=")
    )
)
filtered
}
}
\seealso{
Other Data cleaning and pre-processing: 
\code{\link{aggregate_metadata}()},
\code{\link{aggregate_values_by_key}()},
\code{\link{compute_near_integrations}()},
\code{\link{default_meta_agg}()},
\code{\link{outlier_filter}()},
\code{\link{outliers_by_pool_fragments}()},
\code{\link{purity_filter}()},
\code{\link{realign_after_collisions}()},
\code{\link{remove_collisions}()}
}
\concept{Data cleaning and pre-processing}
\keyword{internal}
