% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis-functions.R
\name{is_sharing}
\alias{is_sharing}
\title{Sharing of integration sites between given groups.}
\usage{
is_sharing(
  ...,
  group_key = c("SubjectID", "CellMarker", "Tissue", "TimePoint"),
  group_keys = NULL,
  n_comp = 2,
  is_count = TRUE,
  relative_is_sharing = TRUE,
  minimal = TRUE,
  include_self_comp = FALSE,
  keep_genomic_coord = FALSE,
  table_for_venn = FALSE
)
}
\arguments{
\item{...}{One or more integration matrices}

\item{group_key}{Character vector of column names which identify a
single group. An associated group id will be derived by concatenating
the values of these fields, separated by "_"}

\item{group_keys}{A list of keys for asymmetric grouping.
If not NULL the argument \code{group_key} is ignored}

\item{n_comp}{Number of comparisons to compute. This argument is relevant
only if provided a single data frame and a single key.}

\item{is_count}{Logical, if \code{TRUE} returns also the count of IS for
each group and the count for the union set}

\item{relative_is_sharing}{Logical, if \code{TRUE} also returns the relative
sharing.}

\item{minimal}{Compute only combinations instead of all possible
permutations? If \code{TRUE} saves time and excludes redundant comparisons.}

\item{include_self_comp}{Include comparisons with the same group?}

\item{keep_genomic_coord}{If \code{TRUE} keeps the genomic coordinates of the
shared integration sites in a dedicated column (as a nested table)}

\item{table_for_venn}{Add column with truth tables for venn plots?}
}
\value{
A data frame
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Computes the amount of integration sites shared between the groups identified
in the input data.
}
\details{
An integration site is always identified by the combination of fields in
\code{mandatory_IS_vars()}, thus these columns must be present
in the input(s).

The function accepts multiple inputs for different scenarios, please refer
to the vignette
\code{vignette("workflow_start", package = "ISAnalytics")}
for a more in-depth explanation.
\subsection{Output}{

The function outputs a single data frame containing all requested
comparisons and optionally individual group counts, genomic coordinates
of the shared integration sites and truth tables for plotting venn diagrams.
}

\subsection{Plotting sharing}{

The sharing data obtained can be easily plotted in a heatmap via the
function \code{\link{sharing_heatmap}} or via the function
\code{\link{sharing_venn}}
}
}
\section{Required tags}{

The function will explicitly check for the presence of these tags:
\itemize{
\item All columns declared in \code{mandatory_IS_vars()}
}
}

\examples{
data("integration_matrices", package = "ISAnalytics")
data("association_file", package = "ISAnalytics")
aggreg <- aggregate_values_by_key(
    x = integration_matrices,
    association_file = association_file,
    value_cols = c("seqCount", "fragmentEstimate")
)
sharing <- is_sharing(aggreg)
sharing
}
\seealso{
Other Analysis functions: 
\code{\link{CIS_grubbs}()},
\code{\link{HSC_population_size_estimate}()},
\code{\link{compute_abundance}()},
\code{\link{cumulative_is}()},
\code{\link{gene_frequency_fisher}()},
\code{\link{iss_source}()},
\code{\link{sample_statistics}()},
\code{\link{top_integrations}()},
\code{\link{top_targeted_genes}()}
}
\concept{Analysis functions}
