% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis-functions.R
\name{compute_abundance}
\alias{compute_abundance}
\title{Computes the abundance for every integration event in the input data frame.}
\usage{
compute_abundance(
  x,
  columns = c("fragmentEstimate_sum"),
  percentage = TRUE,
  key = c("SubjectID", "CellMarker", "Tissue", "TimePoint"),
  keep_totals = FALSE
)
}
\arguments{
\item{x}{An integration matrix - aka a data frame that includes
the \code{mandatory_IS_vars()} as columns. The matrix can either be aggregated
(via \code{aggregate_values_by_key()}) or not.}

\item{columns}{A character vector of column names to process,
must be numeric or integer columns}

\item{percentage}{Add abundance as percentage?}

\item{key}{The key to group by when calculating totals}

\item{keep_totals}{A value between \code{TRUE}, \code{FALSE} or \code{df}. If \code{TRUE},
the intermediate totals for each group will be kept in the output
data frame as a dedicated column with a trailing "_tot". If \code{FALSE},
totals won't be included in the output data frame. If \code{df}, the totals
are returned to the user as a separate data frame, together with the
abundance data frame.}
}
\value{
Either a single data frame with computed abundance values or
a list of 2 data frames (abundance_df, quant_totals)
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Abundance is obtained for every integration event by calculating the ratio
between the single value and the total value for the given group.
}
\details{
Abundance will be computed upon the user selected columns
in the \code{columns} parameter. For each column a corresponding
relative abundance column (and optionally a percentage abundance
column) will be produced.
}
\section{Required tags}{

The function will explicitly check for the presence of these tags:
\itemize{
\item All columns declared in \code{mandatory_IS_vars()}
}
}

\examples{
data("integration_matrices", package = "ISAnalytics")
abund <- compute_abundance(
    x = integration_matrices,
    columns = "fragmentEstimate",
    key = "CompleteAmplificationID"
)
head(abund)
}
\seealso{
Other Analysis functions: 
\code{\link{CIS_grubbs}()},
\code{\link{HSC_population_size_estimate}()},
\code{\link{cumulative_is}()},
\code{\link{gene_frequency_fisher}()},
\code{\link{is_sharing}()},
\code{\link{iss_source}()},
\code{\link{sample_statistics}()},
\code{\link{top_integrations}()},
\code{\link{top_targeted_genes}()}
}
\concept{Analysis functions}
