% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility-functions.R
\name{as_sparse_matrix}
\alias{as_sparse_matrix}
\title{Converts tidy integration matrices in the original sparse matrix
form.}
\usage{
as_sparse_matrix(
  x,
  single_value_col = "Value",
  fragmentEstimate = "fragmentEstimate",
  seqCount = "seqCount",
  barcodeCount = "barcodeCount",
  cellCount = "cellCount",
  ShsCount = "ShsCount",
  key = pcr_id_column()
)
}
\arguments{
\item{x}{A single tidy integration matrix or a list of integration
matrices. Supports also multi-quantification matrices
obtained via \link{comparison_matrix}}

\item{single_value_col}{Name of the column containing the values when
providing a single-quantification matrix}

\item{fragmentEstimate}{For multi-quantification matrix support:
the name of the fragment estimate values column}

\item{seqCount}{For multi-quantification matrix support:
the name of the sequence count values column}

\item{barcodeCount}{For multi-quantification matrix support:
the name of the barcode count values column}

\item{cellCount}{For multi-quantification matrix support:
the name of the cell count values column}

\item{ShsCount}{For multi-quantification matrix support:
the name of the Shs Count values column}

\item{key}{The name of the sample identifier fields (for aggregated
matrices can be a vector with more than 1 element)}
}
\value{
Depending on input, 2 possible outputs:
\itemize{
\item A single sparse matrix (data frame) if input is a single quantification
matrix
\item A list of sparse matrices divided by quantification if input
is a single multi-quantification matrix or a list of matrices
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
This function is particularly useful when a sparse matrix structure
is needed by a specific function (mainly from other packages).
}
\examples{
data("integration_matrices", package = "ISAnalytics")
sparse <- as_sparse_matrix(integration_matrices)
}
\seealso{
Other Utilities: 
\code{\link{comparison_matrix}()},
\code{\link{enable_progress_bars}()},
\code{\link{export_ISA_settings}()},
\code{\link{generate_Vispa2_launch_AF}()},
\code{\link{generate_blank_association_file}()},
\code{\link{generate_default_folder_structure}()},
\code{\link{import_ISA_settings}()},
\code{\link{separate_quant_matrices}()},
\code{\link{transform_columns}()}
}
\concept{Utilities}
