% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/rocCurve-methods.R
\name{rocCurve}
\alias{rocCurve}
\alias{rocCurve,INSPEcT_model,INSPEcT-method}
\title{Display rate classification performance}
\usage{
rocCurve(object, object2, plot = TRUE, comparative = FALSE)

\S4method{rocCurve}{INSPEcT_model,INSPEcT}(object, object2, plot = TRUE, comparative = FALSE)
}
\arguments{
\item{object}{An object of class INSPEcT_model, with true rates}

\item{object2}{An modeled object of class INSPEcT}

\item{plot}{A logical indicating whether ROC curves should be plotted or not}

\item{comparative}{A logical indicating whether the cross-prediction should be visualized. When this mode is selected, 
the p-values assigned to the variability of one rate (e.g. synthesis) are tested against the variability the other rates 
(e.g. processing and degradation). Cross-prediction ROC curves are plotted with dashed lines.}
}
\value{
A list of objects of class pROC with summary of each roc curve
}
\description{
A method to visualize the performance in the classification of synthesis, degradation
and processing rates based on the comparison of the original simulated rates and the one
obtained by the function \code{\link{modelRates}}. For each rate, classification performance is measured 
in terms of sensitivity and specificity using a ROC curve analysis. False negatives (FN) represent cases 
where the rate is identified as constant while it was simulated as varying. False positives (FP) represent 
cases where INSPEcT identified a rate as varying while it was simulated as constant. On the contrary, 
true positives (TP) and negatives (TN) are cases of correct classification of varying and constant rates, respectively. 
Consequently, sensitivity and specificity are computed using increasing thresholds for the brown p-values, 
and the ability of correctly classifying a rate is measured through the area under the curve (AUC) for each rate.
}
\examples{
if( Sys.info()["sysname"] != "Windows" ) {
  nascentInspObj <- readRDS(system.file(package='INSPEcT', 'nascentInspObj.rds'))
 
  simRates<-makeSimModel(nascentInspObj, 1000, seed=1)
   
  # newTpts<-simRates@params$tpts
  # nascentSim2replicates<-makeSimDataset(object=simRates
  #                                    ,tpts=newTpts
  #                                    ,nRep=3
  #                                    ,NoNascent=FALSE
  #                                    ,seed=1)
  # nascentSim2replicates<-modelRates(nascentSim2replicates[1:100]
  #                                ,seed=1)
  # (not evaluated to save computational time)
 
  data("nascentSim2replicates",package='INSPEcT')
 
  rocCurve(simRates[1:100],nascentSim2replicates)
  title("3rep. 11t.p. Total and nascent RNA", line=3)
}
}
\seealso{
\code{\link{makeSimModel}}, \code{\link{makeSimDataset}}, \code{\link{rocThresholds}}
}
